<?php

namespace App\Http\Controllers;

use App\Http\Services\FatoorahService;
use App\Models\Transaction;
use App\Models\Cashier;
use App\Models\Patient;
use Illuminate\Http\Request;
/**
 * @group MyFotoorah payment gateway management
 *
 * APIs to manage MyFatoorah resources
 * */
class FatoorahController extends Controller
{
    private $fatoorahService;

    // injection of the fatoorah service
    public function __construct(FatoorahService $fatoorahService)
    {
        $this->fatoorahService = $fatoorahService;
    }

    public function payOrder(Request $request)
    {
        // Assuming you're passing cashier_id and patient_id in the request
        $cashier = Cashier::findOrFail($request->cashier_id);
        $patient = Patient::findOrFail($request->patient_id);

        $data = [
            'CustomerName' => $patient->name_english,
            'DisplayCurrencyIso' => 'KWD',
            'CustomerEmail' => $patient->email,
            'InvoiceValue' => $cashier->net_price,
            'CallBackUrl' => env('fatoorah_callback'),
            'ErrorUrl' => env('fatoorah_error'),
            'Language' => 'en',
            'NotificationOption' => "LNK"
        ];
        // dd($data);

        $response = $this->fatoorahService->sendPayment($data);

        // Create a new transaction
        $transaction = Transaction::create([
            'cashier_id' => $cashier->id,
            'patient_id' => $patient->id,
            'amount' => $cashier->net_price,
            'status' => 'pending',
            'payment_method' => 'fatoorah',
            'transaction_id' => $response['Data']['InvoiceId'] ?? null,
        ]);

        return $response;
    }

    public function paymentCallback(Request $request)
    {
        $data = [];
        $data['Key'] = $request->paymentId;
        $data['KeyType'] = 'paymentId';
        $paymentStatus = $this->fatoorahService->getPaymentStatus($data);

        // Update the transaction status
        $transaction = Transaction::where('transaction_id', $paymentStatus['Data']['InvoiceId'])->first();
        if ($transaction) {
            $transaction->status = $paymentStatus['Data']['InvoiceStatus'];
            $transaction->save();
        }

        return $paymentStatus;
    }
}
