<?php

namespace App\Http\Controllers;
namespace App\Http\Controllers;


use App\Models\Transaction;
use App\Models\Cashier;
use App\Models\Patient;
use Hesabe\Payment\HesabeCrypt;
use http\Env\Response;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Route;

/**
 * @group Hesabe payment gateway management
 *
 * */
class HesabeController extends Controller
{

//    private $hesabeService;



    // injection of the hesabe service
//    public function __construct(HesabeService $hesabeService)
//    {
//        $this->hesabeService = $hesabeService;
//    }

//    public function payOrder(Request $request): \Illuminate\Http\JsonResponse
//    {
//        // Assuming you're passing cashier_id and patient_id in the request
////        $cashier = Cashier::findOrFail($request->cashier_id);
////        $patient = Patient::findOrFail($request->patient_id);
////payment data containing the following fields {{in encrypted form}} need to be submitted during checkout for initiating the payment request
//        $data = [
////            'amount' => $cashier->net_price,//must be greater than zero (numeric)
//            'amount' => '50',//must be greater than zero (numeric)
//
//            'responseUrl' => 'https://developer.hesabe.com/docs/2.0/request-handler',
//            'failureUrl' => env('HSB_FAILURE_URL'),
//            'merchantCode' => env('HSB_MERCHANT_CODE'),//unique identifier generated by Hesabe for each activated merchant
//            'access_Code' => env('HSB_ACCESS_CODE'),//usd to revalidate a merchant. to be used oly for indirect integration
//            'paymentType' => '0',//payment type 0,1,2 numeric
//            //0->indirect
//            //1->knet
//            //2->visa/mastercard
//            //7->Amex
//            //9->Apple Pay
//            'version' => '2.0',//version of the API example 2.0 (alphanumeric[10])
////            'variable1' => $patient->email,// added for transaction table //these variable1 through variable5 are customer user p$patient->email,arameter which will be included in the response when it returns
//            // these variables are passed in the form of key value pairs in the format "key__value" for example to pass customer name in variable1 you can pass "Customer Name__Ahmed Ismail"
//            'currency'=>'KWD',//available options :kuwaiti dinar:KWD, bahrini dinar: BHD,Emarati Dirham: AED,Omani rial: OMR,Qatari rial: QAR,saudi Rial: SAR,us dollar: USD,british pound: GBP,Euro:EUR
////            'name'=>$patient->name_english,//customer's name (used only with KFast)
////            'email'=>$patient->email,//customer's email address (used only with KFast)
//        ];
//        $request->merge($data);
////        dd(env('HSB_FAILURE_URL'), env('HSB_MERCHANT_CODE'), env('HSB_ACCESS_CODE'));
////         dd($data);
//        $ivKey = env('HSB_IV_KEY');
//        $encryptionKey = env('HSB_ENCRYPTION_KEY');
//        $accessCode = env('HSB_ACCESS_CODE');
//        $checkoutApiUrl = env('HSB_CHECKOUT_API_URL');
////        $paymentUrl = env('HSB_PAYMENT_URL');
//        $requestDataJson = json_encode($request->input());
//        $encryptedData = HesabeCrypt::encrypt($requestDataJson, $encryptionKey, $ivKey);
//
//
//        $baseUrl = 'https://sandbox.hesabe.com';
//        $checkoutApiUrl = $baseUrl . '/checkout';
//        $checkoutRequestData = new Request([ 'data' => $encryptedData ]);
//        $checkoutRequest = Request::create($checkoutApiUrl, 'POST', $checkoutRequestData->all());
//        $checkoutRequest->headers->set('accessCode', $accessCode);
//        $checkoutRequest->headers->set('Accept', 'application/json');   // Only for JSON response
//
//        $checkoutResponse = Route::dispatch($checkoutRequest);
//        $checkoutResponseContent = $checkoutResponse->getContent(); // Use getContent() instead of content()
//
//        $decryptedResponse = HesabeCrypt::decrypt($checkoutResponseContent, $encryptionKey, $ivKey);
//        $responseDataJson = json_decode($decryptedResponse);
//        return response()->json($responseDataJson);
//
//
//////        $response = $this->hesabeService->sendPayment($data);
////
////        // Create a new transaction
////        $transaction = Transaction::create([
////            'cashier_id' => $cashier->id,
////            'patient_id' => $patient->id,
////            'amount' => $cashier->net_price,
////            'status' => 'pending',
////            'payment_method' => 'hesabe',
////            'transaction_id' => $response['Data']['InvoiceId'] ?? null,
////        ]);
//
////        return $response;
//    }



//    public function payOrder(Request $request): \Illuminate\Http\JsonResponse
//    {
//        // Prepare the payment data
//        $data = [
//            'amount' => '50',
//            'responseUrl' => 'https://developer.hesabe.com/docs/2.0/request-handler',
//            'failureUrl' => env('HSB_FAILURE_URL'),
//            'merchantCode' => env('HSB_MERCHANT_CODE'),
//            'access_Code' => env('HSB_ACCESS_CODE'),
//            'paymentType' => '0',
//            'version' => '2.0',
//            'currency' => 'KWD',
//        ];
//
//        $ivKey = env('HSB_IV_KEY');
//        $encryptionKey = env('HSB_ENCRYPTION_KEY');
//        $accessCode = env('HSB_ACCESS_CODE');
//        $checkoutApiUrl = env('HSB_CHECKOUT_API_URL');
//
//        $requestDataJson = json_encode($data);
//        $encryptedData = HesabeCrypt::encrypt($requestDataJson, $encryptionKey, $ivKey);
//
//        // Send the request to the external API using Laravel's HTTP client
//        $response = Http::withHeaders([
//            'accessCode' => $accessCode,
//            'Accept' => 'application/json',
//        ])->post($checkoutApiUrl, [
//            'data' => $encryptedData
//        ]);
//
//        // Decrypt the response from the external API
//        $decryptedResponse = HesabeCrypt::decrypt($response->body(), $encryptionKey, $ivKey);
//
//        // Return the decrypted response as JSON
//        return response()->json(json_decode($decryptedResponse));
//    }


//    use Illuminate\Support\Facades\Http;

//    public function payOrder(Request $request): \Illuminate\Http\JsonResponse
//    {
////        dd(env('HSB_FAILURE_URL'));
//        $data = [
//            'amount' => '50',
//            'responseUrl' => 'https://developer.hesabe.com/docs/2.0/request-handler',
//            'failureUrl' => env('HSB_FAILURE_URL'),
//            'merchantCode' => env('HSB_MERCHANT_CODE'),
//            'access_Code' => env('HSB_ACCESS_CODE'),
//            'paymentType' => '0',
//            'version' => '2.0',
//            'currency' => 'KWD',
//        ];
//
//        // Encrypt data
//        $ivKey = env('HSB_IV_KEY');
//        $encryptionKey = env('HSB_ENCRYPTION_KEY');
//        $accessCode = env('HSB_ACCESS_CODE');
//        $checkoutApiUrl = env('HSB_CHECKOUT_API_URL');
//
//        $requestDataJson = json_encode($data);
////        dd($ivKey);
//        $encryptedData = HesabeCrypt::encrypt($requestDataJson, $encryptionKey, $ivKey);
////dd($encryptedData);
//        // Send the request to Hesabe API using Http client
//        $response = Http::withHeaders([
//           'AccessCode' => '210712aa-7989-4643-9a8b-6d49c8b54cf5',
////             'AccessCode' => 'c333729b-d060-4b74-a49d-7686a8353481',
//
//            'Accept' => 'application/json',
//        ])->post($checkoutApiUrl, [
//            'data' => $encryptedData,
//        ]);
//
//
//        $checkoutResponse = Route::dispatch($checkoutRequest);
//        $checkoutResponseContent = $checkoutResponse->content();
//
////         dd($response);
//        // Decrypt the response
//        $decryptedResponse = HesabeCrypt::decrypt($response->body(), $encryptionKey, $ivKey);
////        dd($decryptedResponse);
////        $responseDataJson = json_decode($decryptedResponse);
////        dd($responseDataJson);
//
//
////        $baseUrl = "https://sandbox.hesabe.com";
////        $paymentUrl = $baseUrl."/payment";
////        $responseToken = $responseDataJson->response->data;
////        return Redirect::to($paymentUrl . '?data='. $responseToken);
//
//
//
////        $decryptedResponse = HesabeCrypt::decrypt($checkoutResponseContent, $encryptionKey, $ivKey);
//        $responseDataJson = json_decode($decryptedResponse);
//
//// Extract the base URL and response token
//        $baseUrl = 'https://sandbox.hesabe.com';
//        $paymentUrl = $baseUrl . '/payment';
//        $responseToken = $responseDataJson->response->data;
//
//// Return the payment URL as part of a JSON response
//        $paymentLink = $paymentUrl . '?data=' . $responseToken;
//
//// Return the link in the API response
//        return response()->json([
//            'payment_url' => $paymentLink
//        ]);
////        return response()->json($responseDataJson);
//    }



//    public function addCard(Request $request): \Illuminate\Http\JsonResponse
//    {
////        dd($request['authorize']);
//        $data = [
//            'amount' => '0',
//            'responseUrl' => 'https://developer.hesabe.com/docs/2.0/request-handler',
//            'failureUrl' => env('HSB_FAILURE_URL'),
//            'merchantCode' => env('HSB_MERCHANT_CODE'),
//            'access_Code' => env('HSB_ACCESS_CODE'),
//            'paymentType' => '15',
//            'subscription'=>'1',
//            'version' => '2.0',
//            'currency' => 'KWD',
////            'authorize'=>$request['authorize']
//        ];
//
//        // Encrypt data
//        $ivKey = env('HSB_IV_KEY');
//        $encryptionKey = env('HSB_ENCRYPTION_KEY');
//        $accessCode = env('HSB_ACCESS_CODE');
//        $checkoutApiUrl = env('HSB_CHECKOUT_API_URL');
//
//        $requestDataJson = json_encode($data);
//        $encryptedData = HesabeCrypt::encrypt($requestDataJson, $encryptionKey, $ivKey);
//
//        // Send the request to Hesabe API using Http client
//        $response = Http::withHeaders([
//            'AccessCode' => $accessCode,
//            'Accept' => 'application/json',
//        ])->post($checkoutApiUrl, [
//            'data' => $encryptedData,
//        ]);
//
//
//// Log or dump the response body to inspect it
////        Log::info($response->body());
//
//        // Decrypt the response
//        $decryptedResponse = HesabeCrypt::decrypt($response->body(), $encryptionKey, $ivKey);
////        dd($decryptedResponse);
//
//        // Check if the response has the expected structure
//        $responseDataJson = json_decode($decryptedResponse);
////        dd($responseDataJson);
//        if (isset($responseDataJson->response->data)) {
//            $responseToken = $responseDataJson->response->data;
//
//            // Prepare payment URL
//            $baseUrl = 'https://sandbox.hesabe.com';
//            $paymentUrl = $baseUrl . '/payment';
//            $paymentLink = $paymentUrl . '?data=' . $responseToken;
//
//            return response()->json([
//                'response'=>$responseDataJson,
//                'payment_url' => $paymentLink
//            ]);
//        } else {
//            return response()->json([
//                'error' => 'Invalid response from Hesabe API'
//            ], 500);
//        }
//    }
    public function payOrder(Request $request): \Illuminate\Http\JsonResponse
    {
//        dd($request['authorize']);
        $data = [
            'amount' => '50',
            'responseUrl' => 'https://developer.hesabe.com/docs/2.0/request-handler',
            'failureUrl' => env('HSB_FAILURE_URL'),
            'merchantCode' => env('HSB_MERCHANT_CODE'),
            'access_Code' => env('HSB_ACCESS_CODE'),
            'paymentType' => '0',
            'version' => '2.0',
            'currency' => 'KWD',
            'authorize'=>$request['authorize']
        ];

        // Encrypt data
        $ivKey = env('HSB_IV_KEY');
        $encryptionKey = env('HSB_ENCRYPTION_KEY');
        $accessCode = env('HSB_ACCESS_CODE');
        $checkoutApiUrl = env('HSB_CHECKOUT_API_URL');

        $requestDataJson = json_encode($data);
        $encryptedData = HesabeCrypt::encrypt($requestDataJson, $encryptionKey, $ivKey);

        // Send the request to Hesabe API using Http client
        $response = Http::withHeaders([
            'AccessCode' => $accessCode,
            'Accept' => 'application/json',
        ])->post($checkoutApiUrl, [
            'data' => $encryptedData,
        ]);


// Log or dump the response body to inspect it
//        Log::info($response->body());

        // Decrypt the response
        $decryptedResponse = HesabeCrypt::decrypt($response->body(), $encryptionKey, $ivKey);
//        dd($decryptedResponse);

        // Check if the response has the expected structure
        $responseDataJson = json_decode($decryptedResponse);
//        dd($responseDataJson);
        if (isset($responseDataJson->response->data)) {
            $responseToken = $responseDataJson->response->data;

            // Prepare payment URL
            $baseUrl = 'https://sandbox.hesabe.com';
            $paymentUrl = $baseUrl . '/payment';
            $paymentLink = $paymentUrl . '?data=' . $responseToken;

            return response()->json([
                'response'=>$responseDataJson,
                'payment_url' => $paymentLink,
            ]);
        } else {
            return response()->json([
                'error' => 'Invalid response from Hesabe API'
            ], 500);
        }
    }




//    function getPaymentStatus(Request $request)
//    {
//        $baseUrl = "https://sandbox.hesabe.com";
//        $transactionApiUrl = $baseUrl."/api/transaction/".$request['data'];
////        dd($transactionApiUrl);
//        $transactionRequestData = new Request();
//        $transactionRequest = Request::create($transactionApiUrl, 'POST', $transactionRequestData->all());
//        $transactionRequest->headers->set('accessCode', env('HSB_ACCESS_CODE'));
//        $transactionRequest->headers->set('Accept', 'application/json');
////        dd($transactionRequest->headers);
////        $transactionResponse = Route::dispatch($transactionRequest);
////        $transactionResponseContent = $transactionResponse->content();
////        return response()->json($transactionResponseContent);
////dd($transactionRequest);
//        return response()->json($transactionRequest);



//    public function getPaymentStatus(Request $request)
//    {
//        // Define the base URL for the API
//        $baseUrl = "https://sandbox.hesabe.com/api/transaction/";
//
//        // Build the full API URL with the transaction token
//        $transactionApiUrl = $baseUrl . $request['data'];
//
//        // Send the request to the Hesabe API
//        $response = Http::withHeaders([
//            'accessCode' => env('HSB_ACCESS_CODE'),
//            'Accept' => 'application/json',
//        ])->get($transactionApiUrl);
//
//        // Check if the request was successful
//        if ($response->successful()) {
//            // Return the decoded JSON response
//            return response()->json($response->json());
//        } else {
//            // Return the error response
//            return response()->json([
//                'status' => false,
//                'message' => 'Failed to fetch transaction status',
//                'error' => $response->body()
//            ]);
//        }
//    }


    public function getPaymentStatus(Request $request)
    {
        // Ensure the request includes the data field
        if (!$request->has('data')) {
            return response()->json([
                'status' => false,
                'message' => 'Data parameter is required'
            ], 400);
        }

        // Define the base URL for the API
        $baseUrl = "https://sandbox.hesabe.com/api/transaction/";

        // Build the full API URL with the data
        $transactionApiUrl = $baseUrl . $request['data'];

        // Send the request to the Hesabe API
        $response = Http::withHeaders([
            'accessCode' => env('HSB_ACCESS_CODE'),
            'Accept' => 'application/json',
        ])->get($transactionApiUrl);
//        dd($response);
        // Check if the request was successful
        if ($response->successful()) {
            // Return the decoded JSON response
            return response()->json($response->json());
        } else {
            // Return the error response
            return response()->json([
                'status' => false,
                'message' => 'Failed to fetch transaction status',
                'error' => $response->body()
            ]);
        }
    }



//        // Define the base URL for the API
//        $baseUrl = "https://sandbox.hesabe.com/api/transaction/";
////        https://sandbox.hesabe.com
//
//        // Build the full API URL with the transaction token or reference number
//        $transactionApiUrl = $baseUrl . $data;
//
//        // Create the request body
//        $requestBody = [];
//
//        if ($isOrderReference) {
//            $requestBody['isOrderReference'] = 1; // Add this if you're using the Order Reference Number
//        }
//
//        // Send the request to the Hesabe API
//        $response = Http::withHeaders([
//            'accessCode' => env('HSB_ACCESS_CODE'),
//            'Accept' => 'application/json',
//        ])->get($transactionApiUrl, $requestBody);
////        dd($transactionApiUrl);
//
//        // Return the decoded JSON response
//        if ($response->successful()) {
//            return $response->json();
//        } else {
//            return [
//                'status' => false,
//                'message' => 'Failed to fetch transaction status',
//                'error' => $response->body()
//            ];
//        }
//    }




    public function paymentCallback(Request $request)
    {
        $data = [];
        $data['Key'] = $request->paymentId;
        $data['KeyType'] = 'paymentId';
        $paymentStatus = $this->hesabeService->getPaymentStatus($data);

//        // Update the transaction status
//        $transaction = Transaction::where('transaction_id', $paymentStatus['Data']['InvoiceId'])->first();
//        if ($transaction) {
//            $transaction->status = $paymentStatus['Data']['InvoiceStatus'];
//            $transaction->save();
//        }

        return $paymentStatus;
    }
}
