<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Validation\Rule;
use Illuminate\Validation\ValidationException;

class StoreCashierRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $id= $this->route('id');// this will get the id in the request link
        return [
            "group"=>["required"],
            "code"=>["required"
                ,"string"
                ,'max:255'
                ,$id? Rule::unique('cashiers')->ignore($id): 'unique:cashiers',

            ],
            "service_name"=>["string","required","exists:services,name_english"],
            "doctor_name"=>["string","required","exists:doctors,name"],
            "QTY"=>["required","integer","min:0"],
            // "price"=>["required","numeric","min:0"],
            // "total"=>["required","numeric","min:0"],
            "discount"=>["required","numeric","min:0","max:100"],
            // "value"=>["required","numeric","min:0"],//مقدار الخصم
            // "net_price"=>["required","numeric","min:0"],//السعر النهائي
        ];
    }

    public function messages(): array
    {
        return [
//            'doctor_id.exists'=>"there is no doctor with the provided id",
//            'service_id.exists'=>"there is no service with the provided id",
            'group.required' => "The service group is required.",
            'code.required' => "The code is required.",
            'code.exists' => "This code already exists in our records.",
//            'service_id.required' => "The service id is required.",
//            'doctor_id.required' => "The doctor id is required.",
            'QTY.required' => "The QTY is required.",
            'QTY.min' => "The QTY should at least be 0",
            'price.required' => "The price is required.",
            'price.min' => "The price should at least be 0",
            'total.required' => "The total is required.",
            'total.min' => "The total should at least be 0",
            'discount.required' => "The discount is required.",
            'discount.max' => "The discount must not exceed 100%.",
            'discount.min' => "The discount should at least be 0%",
            'value.required' => "The value is required.",
            'value.min' => "The value should at least be 0",
            'net_price.required' => "The price is required.",
            'net_price.min' => "The discount should at least be 0",
        ];
    }


    public function failedValidation(Validator $validator): array
    {
        $error = (new ValidationException($validator))->errors();
        throw new HttpResponseException(response()->json([
            'status' => 'error',
            'message' => 'Validation failed',
            'data' => $error,
        ],422));

    }

}
