<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Validation\Rule;
use Illuminate\Validation\ValidationException;

class StoreServiceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }


    public function rules(): array
    {
        $id= $this->route('id');

        return [
            'name_english' => [
                'required',
                'string',
                'max:255',
                'unique:services',
                $id? Rule::unique('services')->ignore($id): 'unique:services',
            ],
            'name_arabic' => [
                'required',
                'string',
                'max:255',
                'unique:services',
                $id? Rule::unique('services')->ignore($id): 'unique:services',
            ],
            'code' => [
                'required',
                'string',
                'max:255',
                'unique:services',
                $id? Rule::unique('services')->ignore($id): 'unique:services',
            ],
            'QTY' => [
//                'required',//made optional because some services may have no quantities
                'integer',
                'min:0'
            ],
            'cost' => [
//                'required',
                'numeric',
                'min:0'],// التكلفه على العياده
            'price' => ['required', 'numeric', 'min:0'],
            //there is no validation called double instead we say numeric
            'service_group_id' => ['required','integer','min:1','exists:service_groups,id'],


        ];
    }


    public function messages(): array
    {

        return[
            'name_english.unique' => "This service english name already exists.",
            'name_arabic.unique' => "This service arabic name already exists.",
            'code.unique' => "This service code already exists.",
            'name_english.required' => "The english name field is required.",
            'name_arabic.required' => "The arabic name field is required.",
            'code.required' => "The code field is required.",
//            'QTY.required' => "The QTY field is required.",
            'QTY.integer'=>'QTY should be a number',
//            'cost.required' => "The cost field is required.",
            'cost.numeric'=>'cost should be a number',
            'price.required' => "The price field is required.",
            'price.numeric'=>'price should be a number',
            'service_group_id'=>'The service group is required.',
            'service_group_id.integer'=>"this service group id doesn't exist in our records",
            "service_group_id.exists"=>"there is no service group with this id"
        ];

    }
    public function failedValidation(Validator $validator): array
    {
        $error = (new ValidationException($validator))->errors();
        throw new HttpResponseException(response()->json([
            'status'=>'error',
            'message'=>'Validation failed',
            'data'=>$error
        ],422));
    }
}
