<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Carbon;

class AppointmentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
//            'doctor' => new DoctorResource($this->whenLoaded('name')),
//            'service' => new ServiceResource($this->whenLoaded('service')),
//            'doctor' => new DoctorResource($this->whenLoaded('doctor')),
//            'service' => new ServiceResource($this->whenLoaded('service')),
            'doctor_id' => $this->doctor->id,
            'service_id' => $this->service->id,
            'date' => $this->date->format('Y-m-d'),
            'start_time' => Carbon::parse($this->start_time)->format('H:i'),
            'end_time' => Carbon::parse($this->end_time)->format('H:i'),
            'is_reserved' => $this->is_reserved,
        ];
    }
}
