<?php
namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\ResourceCollection;

class PatientCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->collection->map(function ($patient) {
            return [
                'id' => $patient->id,
                'name_english' => $patient->name_english,
                'name_arabic' => $patient->name_arabic,
                'email' => $patient->email,
                'civil_id' => $patient->civil_id,
                'phone_number' => $patient->phone_number,
                'phone_home' => $patient->phone_home, // Fixed this line
                'nationality' => $patient->nationality,
                'city' => $patient->city,
                'gender' => $patient->gender,
                'birth_date' => $patient->birth_date,
                'address' => $patient->address,
                'insurance_company' => $patient->insurance_company,
                'policy_holder' => $patient->policy_holder,
                'policy_number' => $patient->policy_number,
                'policy_start_date' => $patient->policy_start_date,
                'policy_end_date' => $patient->policy_end_date,
                'notice' => $patient->notice,
                'referral' => $patient->referral,
                'patient_status' => $patient->patient_status,
                'report_1' => $patient->report_1,
                'report_2' => $patient->report_2,
                'other_document' => $patient->other_document,
                'transactions' => $patient->transactions
            ];
        });
    }
}
