<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Facades\App;

/**
 * @method static findOrFail($id)
 * @method static create(mixed $validatedData)
 * @method static where(string $string, $doctorName)
 * @method static inRandomOrder()
 */
class Doctor extends Model
{
    use HasFactory;
    protected  $fillable=[
        'name',
        'code',
        'type',
        'specialization',
        'work_days',
//        'services',
        'start_time',
        'end_time'
    ];

    protected $casts = [
        'work_days' => 'array', // Automatically decode JSON to an array
    ];

    public function appointment():HasMany
    {
        return $this->hasMany(Appointment::class,'doctor_name');
    }
    public function cashier():BelongsTo
    {
        return $this->belongsTo(Cashier::class,'doctor');
    }


//    public function se+=rvice()
//    {
//        return $this->hasMany(Service::class,'doctor_name');
//    }
}
