<?php

//namespace Database\Factories;
//
//use App\Models\Appointment;
//use App\Models\Doctor;
//use App\Models\Service;
//use Illuminate\Database\Eloquent\Factories\Factory;
//use Illuminate\Support\Carbon;
//
//class AppointmentFactory extends Factory
//{
//    protected $model = Appointment::class;
//
//    public function definition()
//    {
//        // Create a Doctor first
////        $doctor = Doctor::factory()->create();
////        $startTime = Carbon::parse($doctor->start_time);
////        $endTime = Carbon::parse($doctor->end_time);
//
//        $service=Service::inRandomOrder()->first();
//
//
//        $doctor=Doctor::inRandomOrder()->first();
//        $startTime = Carbon::parse($doctor->start_time);
//        $endTime = Carbon::parse($doctor->end_time);
//
//
////        $startTime = Carbon::parse($doctor->start_time);
////        $endTime = Carbon::parse($doctor->end_time);
//
//
//        // Generate a random date within the next week
//        $date = $this->faker->dateTimeBetween('now', '+1 week')->format('Y-m-d');
//
//        // Generate start and end times within the Doctor's working hours
////        $appointmentStartTime = $this->faker->dateTimeBetween($startTime, $endTime);
////        $appointmentEndTime = $this->faker->dateTimeBetween($appointmentStartTime, $endTime); // Ensure at least 1-hour duration
//
//        $appointmentStartTime = Carbon::instance($this->faker->dateTimeBetween($startTime, $endTime));
//        $appointmentEndTime = Carbon::instance($this->faker->dateTimeBetween($appointmentStartTime, $endTime));
//
//
//
////        $appointmentEndTime = Carbon::instance($appointmentStartTime)->addHours(rand(1, 2)); // Ensure at least 1-hour duration
//        return [
//            'doctor_id' => $doctor->id ?? Doctor::factory()->create()->id,// or $doctor->id if you're using IDs
//            'service_id' => $service->id ?? Doctor::factory()->create()->id, // Adjust based on your needs
//            'date' => $date,
//            'start_time' => $appointmentStartTime,
//            'end_time' => $appointmentEndTime,
//            'tag' => 'reserved',
//        ];
//    }
//}




namespace Database\Factories;

use App\Models\Appointment;
use App\Models\Doctor;
use App\Models\Service;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;

class AppointmentFactory extends Factory
{
    protected $model = Appointment::class;

    public function definition(): array
    {
        // Select a random doctor and service
        $doctor = Doctor::inRandomOrder()->first();
        $service = Service::inRandomOrder()->first();

        // Get the doctor's available start and end times
        $startTime = Carbon::parse($doctor->start_time);
        $endTime = Carbon::parse($doctor->end_time);

        // Generate the appointment start time within the doctor's working hours
        $appointmentStartTime = Carbon::parse($this->faker->dateTimeBetween($startTime, $endTime));

        // Generate the appointment end time between the start time and the end of the doctor's working hours
        // Ensure that the end time is later than the start time
        $appointmentEndTime = (clone $appointmentStartTime)->addMinutes(rand(30, 120));

        // Ensure the end time does not exceed the doctor's end time
        if ($appointmentEndTime->greaterThan($endTime)) {
            $appointmentEndTime = $endTime;
        }

        // Return the appointment data
        return [
            'doctor_id' => $doctor->id,
            'service_id' => $service->id,
            'date' => $appointmentStartTime->format('Y-m-d'), // Use the same date for both start and end times
            'start_time' => $appointmentStartTime->format('H:i'),
            'end_time' => $appointmentEndTime->format('H:i'),
            'tag' => 'reserved',
        ];
    }
}
