<?php

namespace Database\Factories;

use App\Models\Service;
use App\Models\ServiceGroup;
use Illuminate\Database\Eloquent\Factories\Factory;

class ServiceFactory extends Factory
{
    protected $model = Service::class;

    public function definition()
    {
        return [
            'code' => $this->faker->unique()->word,
            'name_english' => $this->faker->words(3, true),
            'name_arabic' => $this->faker->words(3, true),
            'QTY' => $this->faker->numberBetween(1, 100),
            'cost' => $this->faker->randomFloat(2, 10, 1000),
            'price' => $this->faker->randomFloat(2, 20, 1500),
            'service_group_id' => ServiceGroup::factory(),
        ];
    }
}
