<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
//    public function up(): void
//    {
//        Schema::create('services', function (Blueprint $table) {
//            $table->id();
//            $table->string('code',255)->unique();// is there a limit ?
//            $table->string('name_english',255)->unique();// is there a limit ?
//            $table->string('name_arabic',255)->unique();// is there a limit ?
//            $table->integer('QTY');//this is the quantity (حقن , حشوات...) // is there a limit ?
//            //integer doesn't accept length
//            $table->double('cost',255);// is there a limit ?
//            $table->double('price',255);// is there a limit ?
//            $table->timestamps();
//        });
//    }



    public function up(): void
    {
        Schema::create('services', function (Blueprint $table) {
            $table->id();
            $table->foreignId('service_group_id')->constrained()->cascadeOnDelete();
            /*
             * when you use the constrained() method in your migration,
             *  it automatically references the table name that matches the foreign key's column name without
             *  you needing to specify the table explicitly
             * */
            $table->string('code', 255)->unique();
            $table->string('name_english', 255)->unique();
            $table->string('name_arabic', 255)->unique();
            $table->integer('QTY')->nullable(); // For quantities
            $table->double('cost', 8, 2)->nullable(); // Precision and scale (8 total digits, 2 after decimal)
            $table->double('price', 8, 2); // Precision and scale (8 total digits, 2 after decimal)
            $table->timestamps();
        });
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('services');
    }
};
