<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('patient_attachments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('patient_id')->constrained('patients','id')->cascadeOnDelete();
            $table->string('civil_id_doc')->nullable();
            $table->string('patient_status_doc')->nullable();
            $table->string('report_1_doc')->nullable();
            $table->string('report_2_doc')->nullable();
            $table->string('other_document_doc')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('patient_attachments');
    }
};
