<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreCashierRequest;
use App\Models\Cashier;
use App\Traits\HttpResponses;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class CashierController extends Controller
{
    use HttpResponses;
//$cashier = Cashier::find($id); // Assuming $id is the ID of the cashier record
//$serviceGroup = $cashier->serviceGroup;
//$services = $serviceGroup->services;


//the front end handles if we chose a specific group the corresponding services to this group appears
    /**
     * Display a listing of the resource.
     */
    public function index(): JsonResponse
    {
        $cashier=Cashier::all();
        return response()->json($cashier);
    }


    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreCashierRequest $request): JsonResponse
    {
        $validatedData=$request->validated();
        $cashier=Cashier::create($validatedData);
        return $this->success($cashier,"cashier created successfully");
    }

    /**
     * Display the specified resource.
     */
    public function show($id): JsonResponse
    {
        $cashier=Cashier::findOrFail($id);
        return response()->json($cashier);
    }



    /**
     * Update the specified resource in storage.
     */
    public function update(StoreCashierRequest $request,$id): JsonResponse
    {
        $validatedData=$request->validated();
//        return $validatedData ;
        $cashier=Cashier::findOrFail($id);
        $cashier->update($validatedData);
        return $this->success($cashier,"cashier was updated successfully");
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id): JsonResponse
    {
        $cashier=Cashier::findOrFail($id);
        $cashier->delete();
        return $this->success("success","the service group has been deleted successfully");
    }
}
