<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreClinicRequest;
use App\Models\Clinic;

use App\Models\Patient;
use App\Traits\HttpResponses;
use http\Env\Response;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class ClinicController extends Controller
{
    use HttpResponses;
    /**
     * Display a listing of the resource.
     */
    public function index(): JsonResponse
    {
        $clinic= Clinic::all();
        return $this->success($clinic);
    }

    public function store(StoreClinicRequest $request): JsonResponse
    {
        $validatedData = $request->validated();

        // Handle logo upload
        $logoPath = $this->handleLogoUpload($request, $validatedData['name_english']);

        // Create the clinic record
        $clinic = Clinic::create([
            'name_english' => $validatedData['name_english'],
            'name_arabic' => $validatedData['name_arabic'],
            'specialization' => $validatedData['specialization'],
            'location' => $validatedData['location'],
            'address' => $validatedData['address'],
            'phone' => $validatedData['phone'],
            'mobile' => $validatedData['mobile'],
            'logo' => $logoPath, // Save the logo path if provided
        ]);

        return $this->success($clinic, "Clinic created successfully");
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(StoreClinicRequest $request, $id): JsonResponse
    {
        $clinic = Clinic::findOrFail($id);
        $validatedData = $request->validated();

        // Handle logo upload
        $logoPath = $this->handleLogoUpload($request, $validatedData['name_english'], $clinic->logo);

        // Update the clinic record
        $clinic->update([
            'name_english' => $validatedData['name_english'],
            'name_arabic' => $validatedData['name_arabic'],
            'specialization' => $validatedData['specialization'],
            'location' => $validatedData['location'],
            'address' => $validatedData['address'],
            'phone' => $validatedData['phone'],
            'logo' => $logoPath,
        ]);

        return $this->success($clinic, "Clinic updated successfully");
    }

    public function show($id): JsonResponse
    {
        $clinic=Clinic::findOrFail($id);
        return response()->json($clinic);
    }

    public function destroy($id):JsonResponse
    {
        $clinic = Clinic::findOrFail($id);
        $clinic->delete();
        return $this->success('',"the clinic has been deleted successfully");
    }


    protected function handleLogoUpload(Request $request, string $nameEnglish, string $currentLogoPath = null): ?string
    {

        //$logoName = Str::replace(' ', '_', trim(pathinfo($validatedData['logo']->getClientOriginalName(), PATHINFO_FILENAME)));
        /*
            pathinfo($validatedData['logo'] //this gets the name that the file was uploaded by
            The pathinfo() function returns information about a file path.
            By passing PATHINFO_FILENAME as the second argument, it specifically extracts just the filename without the extension.
            Example: If the filename is "my-logo.png", pathinfo($validatedData['logo']->getClientOriginalName(), PATHINFO_FILENAME) will return "my-logo".
        */

        if ($request->hasFile('logo')) {
            // Delete old logo if it exists
            if ($currentLogoPath && Storage::disk('logos')->exists($currentLogoPath)) {
                Storage::disk('logos')->delete($currentLogoPath);
            }

            // Store new logo
            $logoName = Str::replace(' ', '_', trim($nameEnglish));
            $fileName = $logoName . "_logo." . $request->file('logo')->getClientOriginalExtension();
            return $request->file('logo')->storeAs($nameEnglish, $fileName, 'logos');
        }

        return $currentLogoPath; // Return current path if no new logo is provided
    }




//    public function store(StoreClinicRequest $request): JsonResponse
//    {
//        $validatedData = $request->validated();
//
////            dd($validatedData['name_english']);
//        // Handle logo upload
//        if ($request->hasFile('logo')) {
//            //$logoName = Str::replace(' ', '_', trim(pathinfo($validatedData['logo']->getClientOriginalName(), PATHINFO_FILENAME)));
//            /*
//                pathinfo($validatedData['logo'] //this gets the name that the file was uploaded by
//                The pathinfo() function returns information about a file path.
//                By passing PATHINFO_FILENAME as the second argument, it specifically extracts just the filename without the extension.
//                Example: If the filename is "my-logo.png", pathinfo($validatedData['logo']->getClientOriginalName(), PATHINFO_FILENAME) will return "my-logo".
//            */
//            $logoName = Str::replace(' ', '_', trim($validatedData['name_english']));
//            $fileName = $logoName. "_logo." . $validatedData['logo']->getClientOriginalExtension();
//            $logoPath = $validatedData['logo']->storeAs($validatedData['name_english'], $fileName, 'logos');
////            dd($logoName);
////            dd($fileName);
////            dd($logoPath);
//        } else {
//            $logoPath = null; // Handle the case where no logo is provided
//        }
//
//        // Create the clinic record
//        $clinic = Clinic::create([
//            'name_english' => $validatedData['name_english'],
//            'name_arabic' => $validatedData['name_arabic'],
//            'specialization' => $validatedData['specialization'],
//            'location' => $validatedData['location'],
//            'address' => $validatedData['address'],
//            'phone' => $validatedData['phone'],
//            'mobile' => $validatedData['mobile'],
//            'logo' => $logoPath, // Save the icon path if provided
//        ]);
//
//        return $this->success($clinic, "Clinic created successfully");
//    }


    /**
     * Update the specified resource in storage.
     */
//    public function update(StoreClinicRequest $request, $id)
//    {
//        $clinic = Clinic::findOrFail($id);
//        $validatedData = $request->validated();
//
//        if ($request->hasFile('logo')) {
//            //$logoName = Str::replace(' ', '_', trim(pathinfo($validatedData['logo']->getClientOriginalName(), PATHINFO_FILENAME)));
//            /*
//                pathinfo($validatedData['logo'] //this gets the name that the file was uploaded by
//                The pathinfo() function returns information about a file path.
//                By passing PATHINFO_FILENAME as the second argument, it specifically extracts just the filename without the extension.
//                Example: If the filename is "my-logo.png", pathinfo($validatedData['logo']->getClientOriginalName(), PATHINFO_FILENAME) will return "my-logo".
//            */
//            $logoName = Str::replace(' ', '_', trim($validatedData['name_english']));
//            $fileName = $logoName. "_logo." . $validatedData['logo']->getClientOriginalExtension();
//            $logoPath = $validatedData['logo']->storeAs($validatedData['name_english'], $fileName, 'logos');
////            dd($logoName);
////            dd($fileName);
////            dd($logoPath);
//        } else {
//            $logoPath = null; // Handle the case where no logo is provided
//        }
//
//
//
//
//        $clinic->update([
//            'english_name'=>$validatedData['name_english'],
//            'name_arabic'=>$validatedData['name_arabic'],
//            'specialization'=>$validatedData['specialization'],
//            'location'=>$validatedData['location'],
//            'address'=>$validatedData['address'],
//            'phone'=>$validatedData['phone'],
//            'logo'=>$logoPath,
//        ]);
//    }

    /**
     * Remove the specified resource from storage.
     */

}
