<?php

namespace App\Http\Controllers;

use App\Http\Requests\StorePatientAttachmentRequest;
use App\Models\Clinic;
use App\Models\Patient;
use App\Models\PatientAttachment;
use App\Traits\HttpResponses;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Str;

class PatientAttachmentController extends Controller
{
    use HttpResponses;
    /**
     * Display a listing of the resource.
     */
    public function index():JsonResponse
    {//show all the attachments for all users
        $patientAttachments=PatientAttachment::all();
        return response()->Json($patientAttachments);
    }


//    public function storeAttachment(StorePatientAttachmentRequest $request): JsonResponse
//    {
//        $validatedData = $request->only(['civil_id', 'civil_id_doc', 'patient_status_doc', 'report_1_doc', 'report_2_doc', 'other_document_doc']);
//        $patient = Patient::where('civil_id', $validatedData['civil_id'])->firstOrFail();
//        $patient_name = $patient->name_english; // Example: 'Ahmed Ali'
//
//        $patient_name = str_replace(' ', '_', trim($patient_name));
//
//        try {
//            $paths = [];
//
//            // Check and store each file
//            if (isset($validatedData['civil_id_doc'])) {
//                $civil_id_doc_name = $patient_name . '_civil_id_doc.' . $validatedData['civil_id_doc']->getClientOriginalExtension();
//                $paths['civil_id_doc'] = $validatedData['civil_id_doc']->storeAs('patientDocs', $civil_id_doc_name, 'public');
//            }
//
//            if (isset($validatedData['patient_status_doc'])) {
//                $patient_status_doc_name = $patient_name . '_patient_status_doc.' . $validatedData['patient_status_doc']->getClientOriginalExtension();
//                $paths['patient_status_doc'] = $validatedData['patient_status_doc']->storeAs('patientDocs', $patient_status_doc_name, 'public');
//            }
//
//            if (isset($validatedData['report_1_doc'])) {
//                $report_1_doc_name = $patient_name . '_report_1_doc.' . $validatedData['report_1_doc']->getClientOriginalExtension();
//                $paths['report_1_doc'] = $validatedData['report_1_doc']->storeAs('patientDocs', $report_1_doc_name, 'public');
//            }
//
//            if (isset($validatedData['report_2_doc'])) {
//                $report_2_doc_name = $patient_name . '_report_2_doc.' . $validatedData['report_2_doc']->getClientOriginalExtension();
//                $paths['report_2_doc'] = $validatedData['report_2_doc']->storeAs('patientDocs', $report_2_doc_name, 'public');
//            }
//
//            if (isset($validatedData['other_document_doc'])) {
//                $other_document_doc_name = $patient_name . '_other_document_doc.' . $validatedData['other_document_doc']->getClientOriginalExtension();
//                $paths['other_document_doc'] = $validatedData['other_document_doc']->storeAs('patientDocs', $other_document_doc_name, 'public');
//            }
//
//            // Update the patient's documents with the file paths
//            $patient->update($paths);
//
//            return $this->success([$patient], "attachment created successfully",);
//
//        } catch (\Exception $e) {
//            // Handle exceptions, e.g., if the patient is not found or if there's a validation error
//            return response()->json(['error' => $e->getMessage()], 500);
//        }
//    }




    /**
     * Store a newly created resource in storage.
     */
    /**
     * Store a newly created resource in storage.
     */
    public function store(StorePatientAttachmentRequest $request): JsonResponse
    {
        $validatedData = $request->all();

        // Use findOrFail to ensure the patient exists or throw a 404 error
        $patient = Patient::findOrFail($validatedData['patient_id']);
        $patientName = Str::replace(' ', '_', trim($patient->name_english));

        $documents = [
            'civil_id_doc' => '_civil_id_doc',
            'patient_status_doc' => '_patient_status_doc',
            'report_1_doc' => '_report_1_doc',
            'report_2_doc' => '_report_2_doc',
            'other_document_doc' => '_other_document_doc',
        ];

        $paths = [];

        foreach ($documents as $key => $suffix) {
            if (isset($validatedData[$key])) {
                $fileName = $patientName . $suffix . '.' . $validatedData[$key]->getClientOriginalExtension();
                $paths[$key] = $validatedData[$key]->storeAs($patientName, $fileName, 'public');
            } else {
                $paths[$key] = null; // Handle case where a document isn't uploaded
            }
        }

        try {
            $patientAttachments = PatientAttachment::create([
                'patient_id' => $validatedData['patient_id'],
                'civil_id_doc' => $paths['civil_id_doc'],
                'patient_status_doc' => $paths['patient_status_doc'],
                'report_1_doc' => $paths['report_1_doc'],
                'report_2_doc' => $paths['report_2_doc'],
                'other_document_doc' => $paths['other_document_doc'],
            ]);

            return response()->json([
                'status' => 'success',
                'data' => $patientAttachments
            ]);

        } catch (Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }



    /**
     * Display the specified resource.
     */
    public function show($id):JsonResponse
    {//show the attachments for a specific user
        $patientAttachments=PatientAttachment::findOrFail($id);
        return response()->Json($patientAttachments);

    }


    /**
     * Update the specified resource in storage.
     */
    public function update(StorePatientAttachmentRequest $request, $id): JsonResponse
    {
        // Update the attachments for a user
        $validatedData = $request->all();
        $patientAttachment = PatientAttachment::findOrFail($id);
        $patient = Patient::findOrFail($validatedData['patient_id']);
        $patientName = Str::replace(' ', '_', trim($patient->name_english));

        $documents = [
            'civil_id_doc' => '_civil_id_doc',
            'patient_status_doc' => '_patient_status_doc',
            'report_1_doc' => '_report_1_doc',
            'report_2_doc' => '_report_2_doc',
            'other_document_doc' => '_other_document_doc',
        ];

        $paths = [];

        foreach ($documents as $key => $suffix) {
            if (isset($validatedData[$key])) {
                $fileName = $patientName . $suffix . '.' . $validatedData[$key]->getClientOriginalExtension();
                $paths[$key] = $validatedData[$key]->storeAs($patientName, $fileName, 'public');
            } else {
                $paths[$key] = $patientAttachment->$key; // Retain the existing path if no new file is uploaded
            }
        }

        try {
            $patientAttachment->update([
                'patient_id' => $validatedData['patient_id'],
                'civil_id_doc' => $paths['civil_id_doc'],
                'patient_status_doc' => $paths['patient_status_doc'],
                'report_1_doc' => $paths['report_1_doc'],
                'report_2_doc' => $paths['report_2_doc'],
                'other_document_doc' => $paths['other_document_doc'],
            ]);

            return response()->json([
                'status' => 'success',
                'data' => $patientAttachment,
            ]);

        } catch (Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }


    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id): JsonResponse
    {//delete the attachments for a specific user
        $patientAttachment = PatientAttachment::findOrFail($id);
        //$patientAttachment->destroy();
        $patientAttachment->delete();
        return $this->success(null,"the patient attachments  has been deleted successfully");
    }
}
