<?php

namespace App\Http\Controllers;

use App\Http\Requests\StorePatientRequest;
use App\Models\Patient;
use App\Traits\HttpResponses;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class PatientController extends Controller
{
    use HttpResponses;
    /**
     * Display a patients
     */
    public function index(): JsonResponse
    {
        $patient = Patient::all();
        return response()->json($patient);
    }


    /**
     * Store a newly created patient
     */
    public function store(StorePatientRequest $request): JsonResponse
    {
        $validatedData = $request->validated();
        $patient = Patient::create($validatedData);
        return $this->success(
            ['patient'=> $patient]
        );
    }

    /**
     * Display patient by id
     */
    public function show($id): JsonResponse
    {
        $patient = Patient::findOrFail($id);
        return response()->json($patient);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(StorePatientRequest $request, $id):JsonResponse
    {
        $patient = Patient::findOrFail($id);
        $validatedData = $request->validated();
        $patient->update($validatedData);
        return $this->success($validatedData,"patient updated successfully");
    }
    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id): JsonResponse
    {
        $patient = Patient::findOrFail($id);
        $patient->delete();
        return $this->success(null,"the patient has been deleted successfully");
    }
}
