<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Validation\ValidationException;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class StoreCustomerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    public function rules() : array
    {
        return [
            'name_english' => ['required','string','max:255'],
            'name_arabic' => ['required','string','max:255'],
            'civil_id' => ['required','string','min:14','max:14','unique:customers'],
            'phone_number' => ['required','string','max:255'],
            'nationality' => ['required','string','max:255'],
            'city' => ['string','max:255'],
            'gender' => ['required','string','max:255'],
            'birth_date' => ['required','string','max:255'],
            'address' => ['string','max:255'],
            'notice' => ['string','max:255'],
            'insurance_company' => ['string','max:255'],
            'policy_holder' => ['string','max:255'],// I want to know what is that for
            'policy_number' => ['string','max:255'],// I want a limit
            'policy_start_date' => ['string','max:255'],
            'policy_end_date' => ['string','max:255'],
            'how_did_you_know_about_us' => ['string','max:255'],



        ];
    }

    public function messages(): array
    {
        return [
            'civil_id.unique' => "This civil id already exists.",
            'civil_id.min' => "the civil id should be 14 consist of 14 number",
            'civil_id.max' => "the civil id should be 14 consist of 14 number",
            'password.required' => "The password field is required.",
            'civil_id.required' => "civil id field is empty",
            'phone_number.required' => "phone number field id is empty",
            'name_english.required' => "name in english field id is empty",
            'gender.required' => "gender field is empty",
            'birth_date.required' => "birth date field   is empty",

        ];
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function failedValidation(Validator $validator): array
    {
        $error = (new ValidationException($validator))->errors();
throw new HttpResponseException(response()->json([
    'status' => 'error',
    'message' => 'Validation failed',
    'data' => $error,
],422));

    }
}
