<?php
namespace Hesabe\Payment;

class Payment
{
private $secretKey;
private $ivKey;
private $accessCode;
private $testEnv;

public function __construct($secretKey, $ivKey, $accessCode, $testEnv = false)
{
$this->secretKey = $secretKey;
$this->ivKey = $ivKey;
$this->accessCode = $accessCode;
$this->testEnv = $testEnv;
}

public function checkout(array $params)
{
$encryptedData = HesabeCrypt::encrypt(json_encode($params), $this->secretKey, $this->ivKey);

if ($encryptedData === false) {
throw new \RuntimeException('Encryption failed.');
}

$curl = curl_init();
curl_setopt_array($curl, array(
CURLOPT_URL => $this->getRedirectBaseUrl() . "/checkout",
CURLOPT_RETURNTRANSFER => true,
CURLOPT_ENCODING => "",
CURLOPT_MAXREDIRS => 10,
CURLOPT_TIMEOUT => 0,
CURLOPT_SSL_VERIFYHOST => 0,
CURLOPT_SSL_VERIFYPEER => 0,
CURLOPT_FOLLOWLOCATION => true,
CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
CURLOPT_CUSTOMREQUEST => "POST",
CURLOPT_POSTFIELDS => http_build_query(['data' => $encryptedData]),
CURLOPT_HTTPHEADER => array(
"accessCode: $this->accessCode",
"Accept: application/json"
),
));

$response = curl_exec($curl);

if (curl_errno($curl)) {
curl_close($curl);
throw new \RuntimeException('CURL Error: ' . curl_error($curl));
}
curl_close($curl);

$decryptedResponse = HesabeCrypt::decrypt($response, $this->secretKey, $this->ivKey);

if ($decryptedResponse === false) {
throw new \RuntimeException('Decryption failed.');
}

$jsonData = json_decode($decryptedResponse, true);

if (json_last_error() !== JSON_ERROR_NONE) {
throw new \RuntimeException('JSON Decode Error: ' . json_last_error_msg());
}

if (isset($jsonData['status']) && !$jsonData['status']) {
return 'Something went wrong';
}

$token = $jsonData['response']['data'] ?? '';

if (empty($token)) {
return 'Invalid response';
}

$baseUrl = $this->getRedirectBaseUrl();
return $baseUrl . "/payment?data=$token";
}

private function getRedirectBaseUrl(): string
{
return $this->testEnv ? 'https://sandbox.hesabe.com' : 'https://api.hesabe.com';
}
}
