<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreServiceGroupRequest;
use App\Models\ServiceGroup;
use App\Traits\HttpResponses;
use Illuminate\Http\JsonResponse;

class ServiceGroupController extends Controller
{
    use HttpResponses;
    /**
     * Display a listing of the resource.
     */
    public function index(): JsonResponse
    {
        $serviceGroup = ServiceGroup::all();
        return response()->json($serviceGroup);
    }
    /**
     * Display the specified resource.
     */
    public function show($id): JsonResponse
    {
        $serviceGroup = ServiceGroup::findOrFail($id);
        return response()->json($serviceGroup);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreServiceGroupRequest $request):JsonResponse
    {
        $validatedData=$request->validated();
        $serviceGroup=ServiceGroup::create($validatedData);
        return $this->success($serviceGroup);
    }


    public function update(StoreServiceGroupRequest $request, $id): JsonResponse
    {
        $validatedData=$request->validated();
        $serviceGroup=ServiceGroup::findOrFail($id);
        $serviceGroup->update($validatedData);
        return $this->success($serviceGroup,"the service group was updated successfully");
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id): JsonResponse
    {
        $serviceGroup = ServiceGroup::findOrFail($id);
        $serviceGroup->delete();
        return $this->success("success","the service group has been deleted successfully");
    }
}
