<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class LoginUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true; // we should make this true
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name'=>['required','string','exists:users,name'],
            'password'=>['required','string','min:6']
        ];
    }

    public function messages(): array
    {
        return [
            'name.exists' => "This user doesn't exist.",
            'password.min' => "The password must be at least 6 characters.",
            'password.required' => "The password field is required.",
        ];
    }

    protected function failedValidation(Validator $validator)
    {
        $errors = (new \Illuminate\Validation\ValidationException($validator))->errors();

        throw new HttpResponseException(response()->json([
            'status' => 'error',
            'message' => 'Validation failed',
            'data' => $errors,
        ], 422));
    }


}
