<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Validation\ValidationException;

class StoreServiceGroupRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            "code"=>["string","required","max:255","unique:service_groups"],
            "name"=>["string","required","max:255","unique:service_groups"]
        ];
    }
    public function messages(): array
    {
        return [
            "code.required"=>"the service group code is required",
            "name"=>"service group name is required"
        ];
    }
    public function failedValidation(Validator $validator): array
    {
        $error = (new ValidationException($validator))->errors();
        throw new HttpResponseException(response()->json([
            'status' => 'error',
            'message' => 'Validation failed',
            'data' => $error,
        ],422));

    }
}
