<?php

namespace App\Http\Requests;

use App\Models\User;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Validation\Rules;
class StoreUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */


public function rules(): array
{
    return [
        'name' => ['required','string','max:255','unique:users'],
        'password' => [
            'required',
            'min:8',
            'confirmed',
            Rules\Password::defaults()]
    ];

//    return [
//        'name' => [
//            'required',
//            'string',
//            'max:255',
//            function ($attribute, $value, $fail) {
//                if (User::where('name', $value)->exists()) {
//                    $fail('The username has already been taken.');
//                }
//            },
//        ],
//        'password' => 'required|string|min:8|confirmed',
//    ];
}

public function messages(): array
{
    return [
        'name.unique' => "This username has already been taken.",
        'password.min' => "The password must be at least 8 characters.",
        'password.required' => "The password field is required.",
        'password.confirmed' => "The password confirmation does not match.",
    ];
}

    protected function failedValidation(Validator $validator)
    {
        $errors = (new \Illuminate\Validation\ValidationException($validator))->errors();

        throw new HttpResponseException(response()->json([
            'status' => 'error',
            'message' => 'Validation failed',
            'data' => $errors,
        ], 422));
    }

}
