<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreCashierRequest;
use App\Http\Resources\CashierCollection;
use App\Http\Resources\CashierResource;
use App\Models\Cashier;
use App\Models\Service;
use App\Traits\HttpResponses;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
/**
 * @group Cashier management
 *
 * APIs to manage Cashier resources
 * */
class CashierController extends Controller
{
    use HttpResponses;
//$cashier = Cashier::find($id); // Assuming $id is the ID of the cashier record
//$serviceGroup = $cashier->serviceGroup;
//$services = $serviceGroup->services;


//the front end handles if we chose a specific group the corresponding services to this group appears

    /*
     * @apiResourceCollection App\Http\Resources\CashierCollection
     * @apiResourceModel App\Models\Cashier
     */
    /**
     * show all cashiers
     * @return JsonResponse
     * @response 200 "success"
     * {
     * "status": "Request was successful",
     * "message": "cashier returned successfully",
     * "data": {
     * "data": [
     * {
     * "id": 3,
     * "group": "surgery",
     * "code": "548",
     * "service_id": 5,
     * "doctor_id": 8,
     * "QTY": 50,
     * "price": 260,
     * "total": 13000,
     * "discount": 85,
     * "value": 11050,
     * "net_price": 1950
     * },
     * {
     * "id": 4,
     * "group": "surgery",
     * "code": "54217",
     * "service_id": 5,
     * "doctor_id": 8,
     * "QTY": 2,
     * "price": 260,
     * "total": 520,
     * "discount": 10,
     * "value": 52,
     * "net_price": 468
     * }
     * ],
     * "meta": {
     * "total_cashiers": 2
     * }
     * }
     * }
     */
    public function index(): JsonResponse
    {
//        $cashier=Cashier::all();
//        return response()->json($cashier);


        $cashiers = Cashier::all(); // Or paginate if needed
        return $this->success(new CashierCollection($cashiers),"cashier returned successfully"); // For multiple resources
    }


    /**
     * Store a newly created resource in storage.
     */
//    public function store(StoreCashierRequest $request): JsonResponse
//    {
//        try {
//            $validatedData=$request->validated();
//
//
//            $service = Service::where('name_english', $validatedData['service'])->first(); // Adjust 'code' to the appropriate field
//            if ($service) {
//                $price = $service->price; // Get the price of the service
//            } else {
//                // Handle the case where the service is not found
//                return $this->error("", "Service not found", 404);
//            }
//
////            $price=$validatedData->price;
//            $discount=$validatedData['discount'];
//            $QTY=$validatedData['QTY'];
//            $total=$QTY*$price;
//            $value=$total*$discount/100;
//            $net_price=$total-$value;
//
//            $cashier = Cashier::create([
//                'group' => $validatedData['group'],
//                'code' => $validatedData['code'],
//                'service' => $validatedData['service'],
//                'doctor' => $validatedData['doctor'],
//                'QTY' => $validatedData['QTY'],
//                'discount' => $validatedData['discount'],
//                'price' => $price,
//                'total' => $total,
//                'value' => $value,//the value of the discount
//                'net_price' => $net_price,
//            ]);
//            return $this->success($cashier, "Cashier created successfully");
//        } catch (\Exception $e) {
//            return $this->error("", "Failed to create cashier: " . $e->getMessage(), 500);
//        }
//    }

    /**
     * Store cashier
     * @response 200 scenario="The request was successful"{
     * "status": "Request was successful",
     * "message": "Cashier created successfully",
     * "data": {
     * "id": 82,
     * "group": "surgery",
     * "code": "5473",
     * "service": "teeth removal",
     * "doctor": "mahmoud ali",
     * "QTY": "2",
     * "price": 100,
     * "total": 200,
     * "discount": "10",
     * "value": 20,
     * "net_price": 180
     * }
     * }
     * @response 404 scenario="The code has already been taken" {
     * "status": "error",
     * "message": "Validation failed",
     * "data": {
     * "code": [
     * "The code has already been taken."
     * ]
     * }
     * }
     * @response 422 scenario="missing parameters"
     * {
     * "status": "error",
     * "message": "Validation failed",
     * "data": {
     * "group": [
     * "The service group is required."
     * ],
     * "code": [
     * "The code is required."
     * ],
     * "service": [
     * "The service name is required."
     * ],
     * "doctor": [
     * "The doctor's name is required."
     * ],
     * "QTY": [
     * "The QTY is required."
     * ],
     * "discount": [
     * "The discount is required."
     * ]
     * }
     * }
     * @param StoreCashierRequest $request
     * @return JsonResponse
     * @bodyParam group string required The name of the service group. Must refer to an existing service group. Example: General
     * @bodyParam code string required A unique code for the cashier entry. Example: 1234
     * @bodyParam service int required The id of the service, must exist in the database. Example: null
     * @bodyParam doctor int required The id of a doctor, must exist in the database. Example: null
     * @bodyParam QTY integer required The quantity of the service provided. Example: 3
     * @bodyParam discount integer optional The discount applied to the service. Example: 10
 */

    public function store(StoreCashierRequest $request): JsonResponse
    {
//            dd("hello");
        try {
            // Validate incoming request
            $validatedData = $request->validated();

            // Find service by id for calculating the price
            $service = Service::findOrFail($validatedData['service_id']);

            if (!$service) {
                return $this->error("", "Service not found", 404);
            }

            // Perform calculations using the model method
            $cashierData = Cashier::calculateCashierData($validatedData, $service->price);

            // Create the Cashier record
            $cashier = Cashier::create(array_merge($validatedData, $cashierData));
//            dd($cashier);
            // Return success response using CashierResource
            return $this->success(new CashierResource($cashier), "Cashier created successfully");

        } catch (\Exception $e) {
            return $this->error("", "Failed to create cashier: " . $e->getMessage(), 500);
        }
    }


    /**
     * @response 200 scenario="The request was successful"
     * {
     * "status": "Request was successful",
     * "message": "cashier deleted successfully",
     * "data": {
     * "id": 3,
     * "group": "surgery",
     * "code": "548",
     * "service_id": 5,
     * "doctor_id": 8,
     * "QTY": 50,
     * "price": 260,
     * "total": 13000,
     * "discount": 85,
     * "value": 11050,
     * "net_price": 1950
     * }
     * }
     * @response 404 scenario="There is no cashier with the specified ID"
     * {
     * "status": "error",
     * "message": "There is no cashier with this ID",
     * "data": ""
     * }
 */
    public function show($id): JsonResponse
    {
//        $cashier=Cashier::findOrFail($id);
//        return response()->json($cashier);

        try {
        $cashier = Cashier::findOrFail($id);
        return $this->success(new CashierResource($cashier),"cashier deleted successfully");
        } catch (ModelNotFoundException $e) {
            return $this->error("", "There is no cashier with this ID", 404);
        }

    }



    /**
     * update cashier
     * @response 200 scenario="the cashier has been created successfully"
     * {
     * "status": "Request was successful",
     * "message": "Cashier has been created successfully",
     * "data": {
     * "id": 3,
     * "group": "surgery",
     * "code": "548",
     * "service_id": "5",
     * "doctor_id": "8",
     * "QTY": "50",
     * "price": 260,
     * "total": 13000,
     * "discount": "85",
     * "value": 11050,
     * "net_price": 1950
     * }
     * }
     * @response 404 scenario="The code has already been taken" {
     * "status": "error",
     * "message": "Validation failed",
     * "data": {
     * "code": [
     * "The code has already been taken."
     * ]
     * }
     * }
     * @response 422 scenario="missing parameters"
     * {
     * "status": "error",
     * "message": "Validation failed",
     * "data": {
     * "group": [
     * "The service group is required."
     * ],
     * "code": [
     * "The code is required."
     * ],
     * "service": [
     * "The service name is required."
     * ],
     * "doctor": [
     * "The doctor's name is required."
     * ],
     * "QTY": [
     * "The QTY is required."
     * ],
     * "discount": [
     * "The discount is required."
     * ]
     * }
     * }
     *@response 404 scenario="This id doesn't exit in our database"{
     * "status": "error",
     * "message": "There is no cashier with this ID",
     * "data": ""
     * }
     *
     * @response 404 scenario="The selected service or doctor aren't in database"{
     * {
     * "status": "error",
     * "message": "Validation failed",
     * "data": {
     * "service": [
     * "there is no service with the provided name"
     * ],
     * "doctor": [
     * "there is no doctor with the provided name"
     * ]
     * }
     * }
     * @param StoreCashierRequest $request
     * @param $id
     * @return JsonResponse
     * @bodyParam group string required The name of the service group. Must refer to an existing service group. Example: General
     * @bodyParam code string required A unique code for the cashier entry. Example: 1234
     * @bodyParam service string required The name of the service, must exist in the database. Example: null
     * @bodyParam doctor string required The doctor's name, must exist in the database. Example: null
     * @bodyParam QTY integer required The quantity of the service provided. Example: 3
     * @bodyParam discount integer optional The discount applied to the service. Example: 10
     */
    public function update(StoreCashierRequest $request,$id): JsonResponse
    {
//        try {
////dd($request);
//            //        return $validatedData ;
//            $cashier=Cashier::findOrFail($id);
//            dd($cashier);
//            $validatedData=$request->validated();
//            $cashier->update($validatedData);
//            return $this->success($cashier,"cashier has been updated successfully");
//        } catch (ModelNotFoundException $e) {
//            // If no service is found, return a 404 error response
//            return $this->error("", "There is no cashier with this ID", 404);
//        }

        try {
            try {

            $cashier = Cashier::findOrFail($id);
            }catch (ModelNotFoundException $e){
                return $this->error("","there is no cashier with the specified id",404);
            }

            $validatedData = $request->validated();

            // Find service by name_english
            $service = Service::findOrFail($validatedData['service_id']);

            if (!$service) {
                return $this->error("", "Service not found", 404);
            }

            // Perform calculations using the model method
            $cashierData = Cashier::calculateCashierData($validatedData, $service->price);

            // Create the Cashier recordupdate
            $cashier->update(array_merge($validatedData, $cashierData));
//            dd($cashier);
            // Return success response using CashierResource
            return $this->success(new CashierResource($cashier), "Cashier has been created successfully");
        }
    catch (\Exception $e) {
return $this->error("", "Failed to create cashier: " . $e->getMessage(), 500);
}
    }

    /**
     * Remove the specified resource from storage.
     * @response 404 scenario="This id doesn't exit in our database"{
     * "status": "error",
     * "message": "There is no cashier with this ID",
     * "data": ""
     * }
     * @responce 200 scenario="cashier has been deleted successfully"
     *  {
     * "status": "Request was successful",
     * "message": "the cashier has been deleted successfully",
     * "data": "success"
     * }
     */
    public function destroy($id): JsonResponse
    {
        try {
        $cashier=Cashier::findOrFail($id);
        $cashier->delete();
        return $this->success("success","the cashier has been deleted successfully");
        } catch (ModelNotFoundException $e) {
            return $this->error("", "There is no cashier with this ID", 404);
        }
    }
}
