<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Validation\ValidationException;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class StorePatientAttachmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }



    public function rules() : array
    {
        return [
            'patient_id' => ['required', 'exists:patients,id'],
            'civil_id_doc' => ['image', 'mimes:jpeg,jpg,png,svg', 'max:2048'],
            'patient_status_doc' => ['image', 'mimes:jpeg,jpg,png,svg', 'max:2048'],
            'report_1_doc' => ['image', 'mimes:jpeg,jpg,png,svg', 'max:2048'],
            'report_2_doc' => ['image', 'mimes:jpeg,jpg,png,svg', 'max:2048'],
            'other_document_doc' => ['image', 'mimes:jpeg,jpg,png,svg', 'max:2048'],
        ];
    }

    public function messages(): array
    {
        return [


        ];
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, ValidationRule|array|string>
     */
    public function failedValidation(Validator $validator): array
    {
        $error = (new ValidationException($validator))->errors();
        throw new HttpResponseException(response()->json([
            'status' => 'error',
            'message' => 'Validation failed',
            'data' => $error,
        ],422));


    }
}
