<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @method static create(mixed $validatedData)
 * @method static findOrFail($id)
 * @method static where(string $string, mixed $service_name)
 * @method static inRandomOrder()
 */
class Service extends Model
{
    use HasFactory;


    protected $fillable=[
        'code',
        'name_english',
        'name_arabic',
        'QTY',
        'cost',
        'price',
        'service_group_id'
        ];

//    public function appointment():BelongsTo
//    {
//        return $this->hasMany(Appointment::class,'service_name');
//    }
    public function serviceGroup():BelongsTo
    {
        return $this->belongsTo(ServiceGroup::class,'service_group_id');
    }
    public function cashier():BelongsTo
    {
        return $this->belongsTo(Cashier::class,'doctor');
    }

//    public function doctor():BelongsTo
//    {
//        return $this->belongsTo(Doctor::class,'doctor_id');
//    }
}
