<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('doctors', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique();//is the doctor name unique ?
            $table->string('code')->unique();//it will be only numbers?
            $table->string('type');//dropdown list   // what is type
            $table->string('specialization');//dropdown list
//            $table->string('services');//coming from services table   //dropdown list //what does it mean
            $table->text('work_days');
            $table->time('start_time'); // HH:MM:SS
            $table->time('end_time'); // HH:MM:SS
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('doctors');
    }
};
