<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('appointments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('doctor_id')->constrained()->onDelete('cascade');
            $table->foreignId('service_id')->constrained()->onDelete('cascade');
            $table->date('date');
            $table->time('start_time');
            $table->time('end_time');
            $table->string('tag')->default('reserved');
            $table->timestamps();
        });

//        Schema::create('appointments', function (Blueprint $table) {
//            $table->id();
//
//
////            $table->string('doctor_name');
////            $table->string('service_name');
////            $table->foreign('doctor_name')->references('name')->on('doctors');
////            $table->foreign('service_name')->references('name_english')->on('services');
//
//            $table->foreignId('doctor_id')->constrained('doctors')->onDelete('cascade');
//            $table->foreignId('service_id')->constrained('services')->onDelete('cascade');
////            $table->index('doctor_name');
////            $table->index('service_name');
////            adding indexes to these columns for faster query performance
//
//
//            $table->date('date');
//            $table->time('start_time');
//            $table->time('end_time');
//            // Add foreign key constraints
//            $table->string('tag')->default('reserved'); // 'reserved' or 'not reserved'
//
//
//
////            $table->foreignId('doctor_name')->constrained('doctors','name');
////            $table->foreignId('service_name')->constrained('services','name_english');
//            $table->timestamps();
//        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('appointments');
    }
};
